#!/usr/bin/python
# -*- coding: utf-8 -*-
## File presupuestos.py
## This file is part of pyArq-Presupuestos.
##
## Copyright (C) 2010-2019 Miguel Ángel Bárcena Rodríguez
##                         <miguelangel@obraencurso.es>
##
## pyArq-Presupuestos is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## pyArq-Presupuestos is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Modules

# python 2/3 compatibility
from __future__ import absolute_import, division, print_function, unicode_literals
from builtins import str as text

import sys
import getopt
import gettext
# pyArq-Presupuestos modules
from Generic import win32Locale
from Generic import globalVars

def _take_APPDATA_path():
    # take path to find mo file
    _path = sys.path[0]
    globalVars.path["APPDATA"]= _path

def _translate():
    """def translate()
    
    Translates the program using gettext module
    """
    _app = "pyArq-Presupuestos"
    _dir = globalVars.path["APPDATA"] + "/mo/"
    if sys.platform == 'win32':
        win32Locale.check_win32_locale()
    kwargs = {}
    if sys.version_info < (3,):
        kwargs['unicode'] = True
    gettext.install(_app, _dir, **kwargs)

def _run_gtk():
    print("Iniciando interfaz Gtk3.")
    from Gtk import gui
    _app = gui.App()
    _app.run(sys.argv)
    
def _run_gui(argumentList):
    """def _run_gui
    
    Shows main window and starts the GTK+ event processing loop.
    """
    unixOptions = "h"
    gnuOptions = ["help"]
    # import before transtale
    from Generic import base
    
    help = base.help
    try:  
        arguments, values = getopt.getopt(argumentList, unixOptions, gnuOptions)
        if len(arguments) > 0:
            for currentArgument, currentValue in arguments:  
                if currentArgument in ("-h", "--help"):
                    print(help)
                    break
                else:
                    _run_gtk()
        else:
            _run_gtk()
    except getopt.error as err:  
        # output error
        print (txt(err))

# Run pyArq-Presupuestos
if __name__ == "__main__":
    _take_APPDATA_path()
    _translate()
    _run_gui(sys.argv[1:])
