#!/usr/bin/python
# -*- coding: utf-8 -*-
## File globalVars.py
## This file is part of pyArq-Presupuestos.
##
## Copyright (C) 2010-2019 Miguel Ángel Bárcena Rodríguez
##                         <miguelangel@obraencurso.es>
##
## pyArq-Presupuestos is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## pyArq-Presupuestos is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.

# module for global variables
# not translatable strings here _("strig")

import os
import sys

name = "pyArq Presupuestos"
version = "v0.0.0"
changeset = "c23"
baseversion = 0

# path: Paths where find the program files needed
path = {
    "HOME" : "",
    "APPDATA" : "",
    "BUDGET": "/pyArq-Presupuestos/budget/",
    "ICON" : "/images/pyArq-Presupuestos.png",
    "ICON16" : "/images/pyArq-Presupuestos-16.svg",
    "ICON32" : "/images/pyArq-Presupuestos-32.svg",
    "ICON64" : "/images/pyArq-Presupuestos-64.svg",
    "ICON128" : "/images/pyArq-Presupuestos-128.svg",
    "CHAPTER-ICON" : "/images/chapter.png",
    "UNIT-ICON" : "/images/unit.png",
    "MATERIAL-ICON" : "/images/material.png",
    "MACHINERY-ICON" : "/images/machinery.png",
    "LABOURFORCE-ICON": "/images/labourforce.png",
    "MENU-ICON": "/images/menu.png",
    "CONNECTED-ICON": "/images/connected.png",
    "DISCONNECTED-ICON": "/images/disconnected.png",
    "CLOSE-ICON": "/images/close.png",
    "HORIZONTAL": "/images/horizontal.svg",
    "VERTICAL": "/images/vertical.svg",
    "DESCRIPTION-ICON": "/images/description.png",
    "SHEET-ICON": "/images/sheet.png",
    "DECOMPOSITION-ICON" : "/images/decomposition.png",
    "MEASURE-ICON" : "/images/measure.png",
    "FILEVIEW-ICON" : "/images/fileview.png",
    "COMPANY-ICON" : "/images/company.png",
    "ACUMULATEDLINE-ICON" : "/images/acumulatedline.png",
    "PARCIALLINE-ICON" : "/images/parcialline.png",
    "NORMALLINE-ICON" : "/images/normalline.png",
    "CALCULATEDLINE-ICON" : "/images/calculatedline.png",
    "ARROW-ICON": "/images/arrow.png",
    "IMAGE-ICON": "/images/image.png",
    "DXF-ICON": "/images/dxf.png",
    "PDF-ICON": "/images/pdf.png",
    "BUDGET-ICON": "/images/budget.png",
    "PYARQ-ICON": "/images/pyArq.png",
    }

color = {
    "ACTIVE" : "#CDD7FF",           # Lavender Blue       (205,215,255,1)
    "INDEX-EVEN" : "#C4C4C4",       # Silver, dark grey   (196,196,196,1)
    "INDEX-UNEVEN" : "#DDDDDD",     # Gainsboro, grey     (221,221,221,1)
    "EVEN" : "#E6E6E6",             # Whisper, dark white (230,230,230,1)
    "UNEVEN": "#FFFFFF",            # White               (255,255,255,1)
    "CHAPTER-EVEN": "#D8E6E6",      # Zircon, dark cian   (216,230,230,1)
    "CHAPTER-UNEVEN": "#F0FFFF",    # Azure, cian         (240,255,255,1)
    "TEXT": "#000000",              # Black               (  0,  0,  0,1)
    "CALCULATED-TEXT": "#FF00FF",   # Magenta             (255,  0,255,1)
    "SUBTOTAL": "#FAC8C8",          # Coral Candy         (250,200,200,1)
    "SUBTOTAL-PARCIAL": "#ADD8E6",  # Light Blue          (173,216,230,1)
    }

desktop = {
    "autodetect" : True,    # True: try to autodect desktop
    "desktop" : "",         # "linux", "macosx" or "windows"
    "browser" : "",         # "firefox"
    "mailapp" : "",         # "evolution"
    "imageapp" : "",        # "gthumb"
    "wmfapp" : "",          # "inkscape"
    "cadapp" : "",          # "librecad"
    "videoapp" : "",        # "vlc"
    "officeapp" : "",       # "libreoffice"
    "txtapp" : "",          # "gedit"
    "rtfapp" : "",          # "libreoffice"
    }

def getAppPath(key):
    return path["APPDATA"] + path[key]

def getHomePath(key):
    return path["HOME"] + path[key]

if os.name == 'posix':
    path["HOME"] = os.environ.get('HOME')
elif sys.platform == 'win32':
    path["HOME"] = os.environ.get('HOMEPATH')
    # TODO: Mac Os, 
    # TODO: Test in diferents os

#-#
path["BUDGET"] = "/pyArq-Presupuestos/"
#-#
